;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: I2CHW_1.asm
;;   Version: 1.4, Updated on 2004/12/22 at 15:01:22
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: I2Cs User Module software implementation file
;;               for the 25/26xxx PSoC family of devices
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2002-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "memory.inc"
include "I2CHW_1Common.inc"

;-----------------------------------------------
; include instance specific register definitions
;-----------------------------------------------

;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
;-------------------------------------------------------------------
;  Declare the functions global for both assembler and C compiler.
;
;  Note that there are two names for each API. First name is
;  assembler reference. Name with underscore is name refence for
;  C compiler.  Calling function in C source code does not require
;  the underscore.
;-------------------------------------------------------------------

export    I2CHW_1_EnableInt
export   _I2CHW_1_EnableInt
export    I2CHW_1_EnableSlave
export   _I2CHW_1_EnableSlave
export    I2CHW_1_EnableMstr
export   _I2CHW_1_EnableMstr
export    I2CHW_1_Start
export   _I2CHW_1_Start
export    I2CHW_1_DisableInt
export   _I2CHW_1_DisableInt
export    I2CHW_1_DisableSlave
export   _I2CHW_1_DisableSlave
export    I2CHW_1_DisableMstr
export   _I2CHW_1_DisableMstr
export    I2CHW_1_Stop
export   _I2CHW_1_Stop


AREA UserModules (ROM, REL)

.SECTION

;-----------------------------------------------------------------------------
;  FUNCTION NAME: I2CHW_1_Start
;
;  DESCRIPTION:
;   Initialize the I2CHW_1 I2C bus interface.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
 I2CHW_1_Start:
_I2CHW_1_Start:
    RAM_PROLOGUE RAM_USE_CLASS_1
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: I2CHW_1_EnableInt
;
;  DESCRIPTION:
;     Enables SDA interrupt allowing start condition detection. Remember to call the
;     global interrupt enable function by using the macro: M8C_EnableGInt.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
 I2CHW_1_EnableInt:
_I2CHW_1_EnableInt:
    RAM_PROLOGUE RAM_USE_CLASS_1
    ;first clear any pending interrupts
    push A
    mov A, reg[INT_CLR3]
    and A, ~I2CHW_1_INT_MASK
    mov reg[INT_CLR3], A
    M8C_EnableIntMask I2CHW_1_INT_REG, I2CHW_1_INT_MASK
    pop A
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret

.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: I2CHW_1_EnableMstr
;
;  DESCRIPTION:
;     Enables SDA interrupt allowing start condition detection. Remember to call the
;     global interrupt enable function by using the macro: M8C_EnableGInt.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
 I2CHW_1_EnableMstr:
_I2CHW_1_EnableMstr:
    RAM_PROLOGUE RAM_USE_CLASS_1
    BitSetI2CHW_1_CFG I2C_M_EN                                       ;Enable SDA interupt
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret

.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: I2CHW_1_EnableSlave
;
;  DESCRIPTION:
;     Enables SDA interrupt allowing start condition detection. Remember to call the
;     global interrupt enable function by using the macro: M8C_EnableGInt.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
 I2CHW_1_EnableSlave:
_I2CHW_1_EnableSlave:
    RAM_PROLOGUE RAM_USE_CLASS_1
    BitSetI2CHW_1_CFG I2C_S_EN                                       ;Enable SDA interupt
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret

.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: I2CHW_1_DisableInt
;  FUNCTION NAME: I2CHW_1_Stop
;
;  DESCRIPTION:
;     Disables I2CHW_1 slave by disabling SDA interrupt
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
 I2CHW_1_DisableInt:
_I2CHW_1_DisableInt:
 I2CHW_1_Stop:
_I2CHW_1_Stop:
    RAM_PROLOGUE RAM_USE_CLASS_1
    M8C_DisableIntMask I2CHW_1_INT_REG, I2CHW_1_INT_MASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret

.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: I2CHW_1_DisableSlave
;
;  DESCRIPTION:
;     Disables I2CHW_1 slave by disabling SDA interrupt
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
 I2CHW_1_DisableSlave:
_I2CHW_1_DisableSlave:
    RAM_PROLOGUE RAM_USE_CLASS_1
    BitClrI2CHW_1_CFG I2C_S_EN                                       ;Disable the Slave
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret

.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: I2CHW_1_DisableMstr
;
;  DESCRIPTION:
;     Disables I2CHW_1 slave by disabling SDA interrupt
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
 I2CHW_1_DisableMstr:
_I2CHW_1_DisableMstr:
    RAM_PROLOGUE RAM_USE_CLASS_1
    BitClrI2CHW_1_CFG I2C_M_EN                                       ;Disable the Master
    RAM_EPILOGUE RAM_USE_CLASS_1
   ret

.ENDSECTION

; End of File I2CHW_1.asm
